#include "UDPHeader.h"
#include <iomanip>

UDPHeader::UDPHeader(u_short _srcPort, u_char _dstPort, u_short _length) 
{
  memset(&data, 0, UDP_HEADER_SIZE);
  data.dstport = _dstPort;
  data.srcport = _srcPort;
  data.length = _length + UDP_HEADER_SIZE;
}

UDPHeader::UDPHeader(const u_char *_data)
{	
  memcpy(&data, _data, UDP_HEADER_SIZE);
  data2host();
}

void UDPHeader::dump()
{
  cout << "UDP Header:" << endl;
  cout << "\tSource port: " << data.srcport << endl;
  cout << "\tDest port: " << data.dstport << endl;
  cout << "\tLength: " << data.length << endl;
  cout << "\tChecksum: 0x" << setbase(16) << setfill('0') << setw(4) << data.checksum << setfill(' ') << setbase(10) << endl << endl << endl;
}

void UDPHeader::setMem(u_char *_data)
{
  data2network();
  memcpy(_data, &data, sizeof(data));
}

const u_short UDPHeader::srcPort() const { 
  return data.srcport; 
}

const u_short UDPHeader::dstPort() const { 
  return data.dstport; 
}

const u_short UDPHeader::length() const { 
  return data.length; 
}

void UDPHeader::data2host(void) {
  data.srcport = ntohs(data.srcport);
  data.dstport = ntohs(data.dstport);
  data.length = ntohs(data.length);
}

void UDPHeader::data2network(void) {
  data.srcport = htons(data.srcport);
  data.dstport = htons(data.dstport);
  data.length = htons(data.length);
}
